/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report.result;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.report.LinkedNode;
import cz.insophy.inplan.report.result.MultiRequestFlowActivityTableRow;
import cz.insophy.inplan.report.result.MultiRequestFlowPathDetailTableRow;
import cz.insophy.inplan.sdgraph.SdgCrNode;
import cz.insophy.inplan.sdgraph.SdgEdge;
import cz.insophy.inplan.sdgraph.SdgEsaNode;
import cz.insophy.inplan.sdgraph.SdgGarNode;
import cz.insophy.inplan.sdgraph.SdgGorNode;
import cz.insophy.inplan.sdgraph.SdgMatprodNode;
import cz.insophy.inplan.sdgraph.SdgNode;
import cz.insophy.inplan.sdgraph.SdgNodeVisitor;
import cz.insophy.inplan.sdgraph.SdgNodeVisitors;
import cz.insophy.inplan.sdgraph.SdgSrNode;
import cz.insophy.inplan.sdgraph.StoreDependencyGraph;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.util.Formatter;
import cz.insophy.inplan.util.Localizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MultiRequestFlowPath {
    private final StoreDependencyGraph sdg;
    private Collection<MultiRequestFlowPath> paths = null;
    private long minPathDate = -9223372036854775708L;
    private long maxPathDate = -9223372036854775708L;
    private final List<SdgNode> nodes;
    private final List<GeneralizedActionRequest> gars;
    private final Map<GeneralizedActionRequest, GeneralizedOrderRequest> garToGor;
    private final Map<GeneralizedActionRequest, GeneralizedActionRequest> garToPrevious;
    private final Map<GeneralizedActionRequest, GeneralizedActionRequest> garToNext;
    private List<MultiRequestFlowPathDetailTableRow> nodeRows;
    private List<MultiRequestFlowActivityTableRow> activityRows;

    public MultiRequestFlowPath(LinkedNode<SdgNode> leafNode, StoreDependencyGraph sdg) {
        this.sdg = sdg;
        this.nodes = Lists.newLinkedList();
        this.gars = Lists.newLinkedList();
        this.garToGor = Maps.newHashMap();
        this.nodeRows = null;
        this.activityRows = null;
        LinkedNode<SdgNode> temp = leafNode;
        do {
            SdgNode node = temp.getValue();
            this.nodes.add(node);
            GeneralizedOrderRequest gor = node.accept(SdgNodeVisitors.GET_GOR_OR_NULL);
            if (gor == null) continue;
            for (GeneralizedActionRequest gar : gor.getGars()) {
                this.gars.add(gar);
                this.garToGor.put(gar, gor);
            }
        } while ((temp = temp.next()) != null);
        this.garToPrevious = Maps.newHashMap();
        this.garToNext = Maps.newHashMap();
        for (int i = 0; i < this.gars.size(); ++i) {
            boolean first = i == 0;
            boolean last = i == this.gars.size() - 1;
            GeneralizedActionRequest current = this.gars.get(i);
            GeneralizedActionRequest prev = first ? null : this.gars.get(i - 1);
            GeneralizedActionRequest next = last ? null : this.gars.get(i + 1);
            this.garToPrevious.put(current, prev);
            this.garToNext.put(current, next);
        }
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public boolean hasGars() {
        return !this.gars.isEmpty();
    }

    public boolean hasGar(GeneralizedActionRequest gar) {
        return this.gars.contains(gar);
    }

    public int getLength() {
        return this.nodes.size();
    }

    public SdgNode getLastNode() {
        Preconditions.checkState(!this.nodes.isEmpty());
        return this.nodes.get(this.nodes.size() - 1);
    }

    public Object getLastNodeContents() {
        GeneralizedOrderRequest gor = this.getLastNode().accept(SdgNodeVisitors.GET_GOR_OR_NULL);
        if (gor != null) {
            return gor;
        }
        CustomerRequest cr = this.getLastNode().accept(SdgNodeVisitors.GET_CR_OR_NULL);
        if (cr != null) {
            return cr;
        }
        throw new IllegalStateException();
    }

    public String getLabelText() {
        Object lastNodeContents = this.getLastNodeContents();
        if (lastNodeContents instanceof GeneralizedOrderRequest) {
            GeneralizedOrderRequest gor = (GeneralizedOrderRequest)lastNodeContents;
            return Localizer.getString("report.multi_request_flow.path_label", Localizer.getString("report.multi_request_flow.path_label_gor", gor.getId()), Formatter.formatMediumDateTime(gor.getDueDate()), (gor.getDueDate() - gor.getEndDate()) / 86400000L, Formatter.formatMediumDateTime(gor.getStartDate()), Formatter.formatMediumDateTime(gor.getEndDate()));
        }
        if (lastNodeContents instanceof CustomerRequest) {
            CustomerRequest cr = (CustomerRequest)lastNodeContents;
            long si = this.getLastNode().getProductionStart();
            long start = si >= 0L ? si : -9223372036854775708L;
            long end = this.getLastNode().getMatprodPreparedTime();
            return Localizer.getString("report.multi_request_flow.path_label", Localizer.getString("report.multi_request_flow.path_label_cr", cr.getId()), Formatter.formatMediumDateTime(cr.getTime()), (cr.getTime() - end) / 86400000L, Formatter.formatMediumDateTime(start), Formatter.formatMediumDateTime(end));
        }
        return Localizer.getString("report.multi_request_flow.path_label_err");
    }

    public Map<Material, Long> getMaterials(GeneralizedActionRequest gar) {
        HashMap<Material, Long> result = Maps.newHashMap();
        SdgGorNode root = this.sdg.getNode(this.getGor(gar));
        List depsEdges = root.getIncomingEdges();
        List<SdgEdge> edges = MultiRequestFlowPath.filterEdges(depsEdges, gar);
        for (SdgEdge edge : edges) {
            Material material = edge.getMaterial();
            long date = edge.getStartTime();
            if (result.containsKey(material)) {
                result.put(material, Math.max((Long)result.get(material), date));
                continue;
            }
            result.put(material, date);
        }
        return Collections.unmodifiableMap(result);
    }

    private static List<SdgEdge> filterEdges(Iterable<SdgEdge> edges, GeneralizedActionRequest gar) {
        LinkedList<SdgEdge> result = Lists.newLinkedList();
        for (SdgEdge edge : edges) {
            Object target;
            if (edge.getMaterial() instanceof Product || !((target = edge.getDestinationStoreActivity().getOriginator()) instanceof ActionActivity) || ((ActionActivity)target).getGar() != gar) continue;
            result.add(edge);
        }
        return Collections.unmodifiableList(result);
    }

    public GeneralizedOrderRequest getGor(GeneralizedActionRequest gar) {
        Preconditions.checkArgument(this.gars.contains(gar));
        Preconditions.checkArgument(this.garToGor.containsKey(gar));
        return this.garToGor.get(gar);
    }

    public GeneralizedActionRequest getPreviousGar(GeneralizedActionRequest gar) {
        Preconditions.checkArgument(this.gars.contains(gar));
        Preconditions.checkArgument(this.garToPrevious.containsKey(gar));
        return this.garToPrevious.get(gar);
    }

    public GeneralizedActionRequest getNextGar(GeneralizedActionRequest gar) {
        Preconditions.checkArgument(this.gars.contains(gar));
        Preconditions.checkArgument(this.garToNext.containsKey(gar));
        return this.garToNext.get(gar);
    }

    public GeneralizedActionRequest getFirstGar() {
        if (this.gars.isEmpty()) {
            return null;
        }
        return this.gars.get(0);
    }

    public GeneralizedActionRequest getLastGar() {
        if (this.gars.isEmpty()) {
            return null;
        }
        return this.gars.get(this.gars.size() - 1);
    }

    public long getSumOuterWaiting() {
        long sum = 0L;
        for (MultiRequestFlowActivityTableRow row : this.getActivityRows()) {
            sum += row.getOuterWaitingTime();
        }
        return sum;
    }

    public long getSumInnerWaiting() {
        long sum = 0L;
        for (MultiRequestFlowActivityTableRow row : this.getActivityRows()) {
            sum += row.getInnerWaitingTime();
        }
        return sum;
    }

    public long getSumLogistic() {
        long sum = 0L;
        for (MultiRequestFlowActivityTableRow row : this.getActivityRows()) {
            sum += row.getLogisticTime();
        }
        return sum;
    }

    public long getSumProduction() {
        long sum = 0L;
        for (MultiRequestFlowActivityTableRow row : this.getActivityRows()) {
            sum += row.getProductionTime();
        }
        return sum;
    }

    public void setup(Collection<MultiRequestFlowPath> allPaths) {
        Preconditions.checkNotNull(allPaths);
        Preconditions.checkArgument(allPaths.contains(this));
        this.paths = allPaths;
        this.minPathDate = Long.MAX_VALUE;
        this.maxPathDate = Long.MIN_VALUE;
        for (MultiRequestFlowPath path : this.paths) {
            if (!path.hasGars()) continue;
            this.minPathDate = Math.min(this.minPathDate, path.getFirstGar().getReleaseDate());
            this.maxPathDate = Math.max(this.maxPathDate, path.getLastGar().getEndDate());
        }
    }

    public void initialize() {
        Preconditions.checkNotNull(this.paths);
        Preconditions.checkArgument(this.paths.contains(this));
        this.nodeRows = this.computeNodeRows();
        this.activityRows = this.computeActivityRows();
    }

    public List<MultiRequestFlowPathDetailTableRow> getNodeRows() {
        Preconditions.checkNotNull(this.nodeRows);
        return Collections.unmodifiableList(this.nodeRows);
    }

    public List<MultiRequestFlowActivityTableRow> getActivityRows() {
        Preconditions.checkNotNull(this.activityRows);
        return Collections.unmodifiableList(this.activityRows);
    }

    public List<MultiRequestFlowPathDetailTableRow> computeNodeRows() {
        Preconditions.checkNotNull(this.nodes);
        Preconditions.checkState(!this.nodes.isEmpty());
        final ArrayList<MultiRequestFlowPathDetailTableRow> rows = Lists.newArrayListWithCapacity(16);
        SdgNodeVisitor<MultiRequestFlowPathDetailTableRow> visitor = new SdgNodeVisitor<MultiRequestFlowPathDetailTableRow>(){

            @Override
            public MultiRequestFlowPathDetailTableRow visit(SdgSrNode node) {
                return new MultiRequestFlowPathDetailTableRow(rows.size() + 1, node.getSupplyRequest());
            }

            @Override
            public MultiRequestFlowPathDetailTableRow visit(SdgCrNode node) {
                return new MultiRequestFlowPathDetailTableRow(rows.size() + 1, node.getCustomerRequest());
            }

            @Override
            public MultiRequestFlowPathDetailTableRow visit(SdgGorNode node) {
                return new MultiRequestFlowPathDetailTableRow(rows.size() + 1, node.getGor());
            }

            @Override
            public MultiRequestFlowPathDetailTableRow visit(SdgGarNode node) {
                return new MultiRequestFlowPathDetailTableRow(rows.size() + 1, node.getGar());
            }

            @Override
            public MultiRequestFlowPathDetailTableRow visit(SdgEsaNode node) {
                return new MultiRequestFlowPathDetailTableRow(rows.size() + 1, node.getEsa());
            }

            @Override
            public MultiRequestFlowPathDetailTableRow visit(SdgMatprodNode node) {
                return new MultiRequestFlowPathDetailTableRow(rows.size() + 1, node.getMatprod());
            }
        };
        for (SdgNode node : this.nodes) {
            rows.add(node.accept(visitor));
        }
        return Collections.unmodifiableList(rows);
    }

    public List<MultiRequestFlowActivityTableRow> computeActivityRows() {
        Preconditions.checkNotNull(this.paths);
        Preconditions.checkState(!this.paths.isEmpty());
        ArrayList<MultiRequestFlowActivityTableRow> rows = Lists.newArrayListWithCapacity(64);
        for (GeneralizedActionRequest gar : this.gars) {
            rows.add(new MultiRequestFlowActivityTableRow(rows.size() + 1, this, this.paths, gar));
        }
        return Collections.unmodifiableList(rows);
    }
}

